# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def sunshine_optimist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Start with cooperation to build trust
    
    total_rounds = 10
    current_round = len(my_history) + 1
    
    # Check for always-defect opponent
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Switch to always defect if opponent defected >=3 times in a row
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Late-game adjustment: last 2 rounds
    if current_round >= total_rounds - 1:
        opponent_defects = opp_history.count("D")
        if opponent_defects > 2:
            return "D"
        else:
            if current_round == total_rounds:
                return "D"
            else:
                return "C"
    
    # Tit-for-Tat with 10% noise
    last_opponent_move = opp_history[-1]
    if random.random() < 0.1:
        return "D" if last_opponent_move == "C" else "C"  # Random flip
    else:
        return last_opponent_move